VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.OCX"
Begin VB.UserControl CTreeView 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ClipControls    =   0   'False
   ScaleHeight     =   3600
   ScaleWidth      =   4800
   Begin MSComctlLib.TreeView TreeView1 
      Height          =   2895
      Left            =   480
      TabIndex        =   0
      Top             =   360
      Width           =   3795
      _ExtentX        =   6694
      _ExtentY        =   5106
      _Version        =   393217
      HideSelection   =   0   'False
      Indentation     =   18
      LabelEdit       =   1
      Style           =   7
      Appearance      =   1
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   480
      Top             =   2820
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      MaskColor       =   12632256
      _Version        =   393216
   End
End
Attribute VB_Name = "CTreeView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------
'------------------------------------------------------------------
' Private Variables
'------------------------------------------------------------------
'------------------------------------------------------------------

Dim mo_OutlineAdditionalInformation As New Collection

Dim ms_OutlineParameter() As String
Dim ms_OutlineNodeParameter() As String
Dim ml_Key As Long
Dim mi_OutlineFilterCount As Integer
Dim ms_OutlineFilter() As String
Dim mb_FirstLevelInCombo As Boolean
Dim mo_ViewCombo As Object
Dim mb_LeafStringData As Boolean

Dim ms_ParamSystem As String 'Define for which system the outline work (it's used for getting the appropriate data in the SGBD)
Dim ms_LanguageCode As String 'Define the language code to use
Dim ms_LeafCode As String 'Code of the selected element if exist
Dim ms_SearchReq As String
Dim mb_OnNodeClick As Boolean
Dim mb_DblClickFired As Boolean
Dim ms_DefaultComboView As String ' Define the default view to select in the combo box, if information must be displayed

Private mb_Use_NCS_ODBC As Boolean

















'------------------------------------------------------------------
'------------------------------------------------------------------
' Public Events
'------------------------------------------------------------------
'------------------------------------------------------------------

Public Event Resize()
Public Event DblClick()
Public Event EvtLeafClick(ByVal ls_OutLineCode As String, ByVal ls_OutlineDesc As String)
Public Event EvtNodeClick(ByVal ls_OutLineCode As String, ByVal ls_OutlineDesc As String)
Public Event EvtLooseSelection()










' Private type
Private Type dataItem
    Code As String
    Desc As String
End Type














'------------------------------------------------------------------
'------------------------------------------------------------------
' Public Attributs
'------------------------------------------------------------------
'------------------------------------------------------------------

Public Property Get Use_NCS_ODBC() As Boolean
    Use_NCS_ODBC = mb_Use_NCS_ODBC
End Property

Public Property Let Use_NCS_ODBC(lb_Use_NCS_ODBC As Boolean)
    mb_Use_NCS_ODBC = lb_Use_NCS_ODBC
    PropertyChanged "Use_NCS_ODBC"
End Property

Public Property Get Enabled() As Boolean
    Enabled = TreeView1.Enabled
End Property

Public Property Let Enabled(lb_Use_NCS_ODBC As Boolean)
    TreeView1.Enabled = Enabled
    PropertyChanged "Enabled"
End Property


Property Let s_DefaultComboView(ByVal ls_DefaultComboView As String)
'------------------------------------------------------------------
' Name :s_DefaultComboView
'
' Purpose :Define the default view to select in the combo box, if information must be displayed
'
'
' review : 29/Juin/2000 by JJB
'------------------------------------------------------------------
    ms_DefaultComboView = ls_DefaultComboView
End Property


Property Let s_SearchReq(ByVal ls_SearchReq As String)
'------------------------------------------------------------------
' Name :s_SearchReq
'
' Purpose :Set the SQL Function to use for searching leaf
'
'
' review : 30/May/2000 by JJB
'------------------------------------------------------------------
    ms_SearchReq = ls_SearchReq
End Property

Property Let i_OutlineFilterCount(ByVal li_OutlineFilterCount As Integer)
'------------------------------------------------------------------
' Name :i_OutlineFilterCount
'
' Purpose :Change the number of Filter. Warning, this cause to reinit all old filter
'
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    mi_OutlineFilterCount = li_OutlineFilterCount
    ReDim ms_OutlineFilter(mi_OutlineFilterCount)
End Property

Property Let s_FilterValue(ByVal li_FilterCount As Integer, ByVal ls_FilterValue)
'------------------------------------------------------------------
' Name :s_FilterValue
'
' Purpose :Change the Value of a Filter
'
' Param:    li_FilterCount  : Filter number to change
'           ls_FilterValue  : New Value for the filter
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    ms_OutlineFilter(li_FilterCount) = ls_FilterValue
End Property

Property Let b_LeafStringData(ByVal lb_LeafStringData)
    mb_LeafStringData = lb_LeafStringData
End Property

Property Let b_FirstLevelInCombo(ByVal lb_FirstLevelInCombo As Boolean)
'------------------------------------------------------------------
' Name :b_FirstLevelInCombo
'
' Purpose :Tell to the CTreeView if we use a combo box to change the first level of the tree view
'
' Param:    lb_FirstLevelInCombo  : OK if we use a combo
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    mb_FirstLevelInCombo = lb_FirstLevelInCombo
End Property

Property Get s_LeafCode() As String
'------------------------------------------------------------------
' Name :s_LeafCode
'
' Purpose :Get the code of the leaf item selected if exist, "" if not
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    s_LeafCode = ms_LeafCode
End Property

Property Let s_LanguageCode(ByVal ls_LanguageCode As String)
'------------------------------------------------------------------
' Name :s_LanguageCode
'
' Purpose :Set the language code for displaying information in the tree
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    ms_LanguageCode = ls_LanguageCode
End Property

Property Let s_ParamSystem(ByVal ls_SystemName As String)
'------------------------------------------------------------------
' Name :s_ParamSystem
'
' Purpose :Set the system name to the CTreeView. This param define which tree to display (used by the SGBD)
'          This property must be set before reinit the outline
'
' Param:    ls_SystemName  : System name to use
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    ms_ParamSystem = ls_SystemName
    ReDim ms_OutlineParameter(0)
    GetOutlineParameter
End Property


Property Set o_ViewCombo(ByRef lo_ViewCombo As Object)
'------------------------------------------------------------------
' Name :o_ViewCombo
'
' Purpose : Link to the Combo box that change the view
'           We must set mb_FirstLevelInCombo to OK if you use a combo
'
' Param:    lo_ViewCombo  : reference to an existing combo box in the form
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    Set mo_ViewCombo = lo_ViewCombo
End Property




























'------------------------------------------------------------------
'------------------------------------------------------------------
' Public Sub & Function Part
'------------------------------------------------------------------
'------------------------------------------------------------------

Public Sub ListImageAdd(ByVal lv_Key As Variant, lo_Picture As Object)
'------------------------------------------------------------------
' Name :ListImageAdd
'
' Purpose : Reference an image to use in the TreeView
'
' Param :   lv_Key      : an ID that uniquely reference the new Picture
'           lo_Picture  : The picture
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    ImageList1.ListImages.Add , lv_Key, lo_Picture
    If TypeName(TreeView1.ImageList) = "Nothing" Then
       Set TreeView1.ImageList = ImageList1
    End If
End Sub

Public Sub Reinit()
'------------------------------------------------------------------
' Name :ListImageAdd
'
'Purpose : Close all the outline and re-fill only the first level
'
'
' review :  by JJB
'------------------------------------------------------------------

Dim li_Count As Integer
Dim lo_CursNode As Node
    
    For li_Count = 1 To mo_OutlineAdditionalInformation.Count
        'Set mo_OutlineAdditionalInformation.Item(1) = Nothing
        mo_OutlineAdditionalInformation.Remove 1
    Next
    ' in order to speeding up the clear process, we close all branch
    If TreeView1.Nodes.Count > 0 Then
        Set lo_CursNode = TreeView1.Nodes.Item(1)
        Do While TypeName(lo_CursNode) <> "Nothing"
            lo_CursNode.Expanded = KO
            Set lo_CursNode = lo_CursNode.Next
        Loop
    End If
    TreeView1.Nodes.Clear
    ml_Key = 0
    If mb_FirstLevelInCombo Then
        mo_ViewCombo.Clear
    End If
    ' fill the test outline
    FillLevel Nothing, 1, "", "", ""
End Sub


Public Function TreeViewGetNext(lo_parentNode As Node, lo_Node As Node) As Node
'------------------------------------------------------------------
' Name :TreeViewGetNext
'
'Purpose : Get the Next Node of lo_Node that have lo_ParentNode as node (the first parent that have a SGBD ID, not all directories
'   datas have an ID)
'   In fact, we use the standard properties of the node execpt in case of we are on directories data.
'   in this case the technique is a lite bit more complicated since not all nodes displayed of directories data
'   have an SGBD ID
'
'
' review :  by JJB
'------------------------------------------------------------------

Dim lo_OutlineData As OutlineData
Dim lo_OutlineDataNext As OutlineData
Dim ls_SearchedParentPath As String
Dim lb_OldNodeFound As Boolean
Dim ls_Key As String
Dim li_CursNode As Integer

    Set TreeViewGetNext = Nothing
    ls_Key = lo_Node.Key
    lb_OldNodeFound = KO
    Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(ls_Key)
    If lo_OutlineData.lb_DirectoryData = OK Then

        ls_SearchedParentPath = TreeViewGetPath(lo_parentNode)

        For li_CursNode = 1 To TreeView1.Nodes.Count
            Set lo_OutlineDataNext = mo_OutlineAdditionalInformation.Item(TreeView1.Nodes.Item(li_CursNode).Key)
            If lo_OutlineDataNext.lb_TerminalDirectoryData = OK Then
                If TreeViewGetPath(TreeView1.Nodes.Item(li_CursNode).Parent) = ls_SearchedParentPath Then
                    If lb_OldNodeFound = OK Then
                        Set TreeViewGetNext = TreeView1.Nodes.Item(li_CursNode)
                        Exit Function
                    End If
                    If TreeView1.Nodes.Item(li_CursNode).Key = lo_Node.Key Then
                        lb_OldNodeFound = OK
                    End If
                End If
            End If
        Next
    Else
        Set TreeViewGetNext = lo_Node.Next
    End If
    
End Function


Public Function GetPath() As String
'------------------------------------------------------------------
' Name :GetPath
'
' Purpose : Get the path of actual selected item
'
' review :  by JJB
'------------------------------------------------------------------

    GetPath = TreeViewGetPath(TreeView1.SelectedItem)
End Function

Public Function GetPathDesc() As String
'------------------------------------------------------------------
' Name :GetPath
'
' Purpose : Get the path of actual selected item
'
' review :  by JJB
'------------------------------------------------------------------
    GetPathDesc = ""
    
    On Error Resume Next

    GetPathDesc = TreeView1.SelectedItem.FullPath
End Function

Public Sub SetPath(ByVal ls_path As String)
'------------------------------------------------------------------
' Name :SetPath
'
' Purpose : Open the outline at the given path
'
' review :  by JJB
'------------------------------------------------------------------

     TreeViewOpenPath (ls_path)
End Sub

Public Sub PrintTree()
'------------------------------------------------------------------
' Name :PrintTree
'
' Purpose : Print in the opened printer flow, the tree
'
' review :  by JJB
'------------------------------------------------------------------

    TreeViewPrintNode TreeView1.Nodes.Item(1).Root
End Sub


Public Sub ReFillChildOutline()
'------------------------------------------------------------------
' Name :ReFillChildOutline
'
' Purpose : refresh a part of the outline. Clear then try to re-open all visible open sub-branch of the current position
'
'
' review : 2/Dec/1999 by JJB
'------------------------------------------------------------------
Dim lo_TestedNode As Node
Dim lo_CursParentTestedNode As Node
Dim lo_SelectedNode As Node

Dim lo_OutlineData As OutlineData
Dim lo_PathToRefresh As New Collection
Dim lo_NodesToKill As New Collection

Dim li_CursNode As Integer
Dim li_CursNodesToKill As Integer
Dim li_CursPathToRefresh As Integer
Dim lb_Child As Boolean
'
' record the selected node
Set lo_SelectedNode = TreeView1.SelectedItem

'if no node is selected, there is no opened path so we reinit the outline
If TypeName(lo_SelectedNode) = "Nothing" Then
     Reinit
     Exit Sub
End If


'
''record all opened path
For li_CursNode = 1 To TreeView1.Nodes.Count
    ' test node by node, if the node as the selected node as parent
    Set lo_TestedNode = TreeView1.Nodes.Item(li_CursNode)
    'Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_TestedNode.Key)
    
    lb_Child = KO
    Set lo_CursParentTestedNode = lo_TestedNode.Parent
    Do While TypeName(lo_CursParentTestedNode) <> "Nothing"
        If lo_SelectedNode.Key = lo_CursParentTestedNode.Key Then 'if the node as the selected node as parent
            lb_Child = OK
            On Error Resume Next
            ' add the node to the list of nodes to delete (if it exist in the list, it will raise an error that we trap)
            lo_NodesToKill.Add lo_TestedNode.Key, lo_TestedNode.Key
            On Error GoTo 0
            Exit Do
        End If
        Set lo_CursParentTestedNode = lo_CursParentTestedNode.Parent
    Loop
    
    'record only opened path
    If lb_Child And lo_TestedNode.children <> 0 Then
        lo_PathToRefresh.Add TreeViewGetPath(lo_TestedNode)
    End If

Next

For li_CursNodesToKill = 1 To lo_NodesToKill.Count
    mo_OutlineAdditionalInformation.Remove lo_NodesToKill.Item(li_CursNodesToKill)
    On Error Resume Next
    TreeView1.Nodes.Remove lo_NodesToKill.Item(li_CursNodesToKill)
    On Error GoTo 0
Next

FillLevel lo_SelectedNode, TreeViewGetHeight(lo_SelectedNode) + 1, TreeViewGetPath(lo_SelectedNode), TreeViewGetView(lo_SelectedNode), ""
For li_CursPathToRefresh = 1 To lo_PathToRefresh.Count
    TreeViewOpenPath lo_PathToRefresh.Item(li_CursPathToRefresh), OK
Next

lo_SelectedNode.Selected = OK
End Sub


Public Sub LocalDelItem(ByVal ls_OutLineCode As String)
'------------------------------------------------------------------
' Name :LocalDelItem
'
' Purpose : remove leaves referenced by the ID of the element from all branch of the displayed tree
'
' Param :   ls_OutLineCode : code of the leaf to remove from all opened branch of the tree
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

Dim li_CursNode As Integer
Dim lo_OutlineData As OutlineData
Dim ls_Key As String
Dim lo_Parent As Node
    
    li_CursNode = 1
    Do While li_CursNode <= TreeView1.Nodes.Count
        ls_Key = TreeView1.Nodes.Item(li_CursNode).Key
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(ls_Key)
        If (lo_OutlineData.lb_TerminalData = OK) And (lo_OutlineData.ls_ID = ls_OutLineCode) Then
            Set lo_Parent = TreeView1.Nodes(ls_Key).Parent
            TreeView1.Nodes.Remove (ls_Key)
            mo_OutlineAdditionalInformation.Remove (ls_Key)
            Do While TypeName(lo_Parent) <> "Nothing"
                If lo_Parent.children = 0 Then
                    ls_Key = lo_Parent.Key
                    Set lo_Parent = lo_Parent.Parent
                    TreeView1.Nodes.Remove (ls_Key)
                    mo_OutlineAdditionalInformation.Remove (ls_Key)
        Else
                    Set lo_Parent = Nothing
                End If
            Loop
        Else
            li_CursNode = li_CursNode + 1
        End If
    Loop
End Sub

Public Sub LocalDelCurrentFolder()
'------------------------------------------------------------------
' Name :LocalDelCurrentFolder
'
' Purpose : remove leaves referenced by the ID of the element from all branch of the displayed tree
'
' Param :   ls_OutLineCode : code of the leaf to remove from all opened branch of the tree
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

Dim lo_OutlineData As OutlineData
Dim ls_Key As String
Dim lo_Parent As Node
    
    Set lo_Parent = TreeView1.SelectedItem.Parent
    ls_Key = TreeView1.SelectedItem.Key
    TreeView1.Nodes.Remove (ls_Key)
    mo_OutlineAdditionalInformation.Remove (ls_Key)
    Do While TypeName(lo_Parent) <> "Nothing"
        If lo_Parent.children = 0 Then
            ls_Key = lo_Parent.Key
            Set lo_Parent = lo_Parent.Parent
            TreeView1.Nodes.Remove (ls_Key)
            mo_OutlineAdditionalInformation.Remove (ls_Key)
        Else
            Set lo_Parent = Nothing
        End If
    Loop
End Sub

Public Sub LocalAddItem(ByVal ls_OutLineCode As String)
'------------------------------------------------------------------
' Name :LocalAddItem
'
' Purpose :take a new code and a description of an element of the outline, then add this element at each opened branch where it must appear
'
' param :
'   ls_OutLineCode : the code of the element to add
'
'
' review : 10/Mars/2000 by JJB
'------------------------------------------------------------------
Dim li_CursFilter As Integer
Dim ls_req As String
Dim ls_path As String
Dim ls_ActualPath As String
Dim ls_ProposalPath As String
Dim ls_Desc As String
Dim li_CurrSoundLike As Integer
Dim li_ProposalSoundLike As Integer
Dim li_status1 As Integer
Dim li_Status As Integer
Dim ll_Statement As Long
Dim li_Count As Integer
Dim lo_OutlineData As OutlineData
Dim lo_ListOfPossibility() As String
ReDim lo_ListOfPossibility(2, 0) As String
Dim lb_Result As Boolean
On Error Resume Next
    If mb_FirstLevelInCombo Then
        If mo_ViewCombo.ListIndex = -1 Then
            SetComboView (ms_DefaultComboView)
        End If
    End If
    'init some variable
    li_status1 = KO
    
    'ls_ActualPath = out_Test2.FullPath(out_test.ListIndex)
    ls_ActualPath = TreeViewGetPath(TreeView1.SelectedItem)

    ls_ProposalPath = ""
    li_ProposalSoundLike = 0

    ' get all path where the element must appear from the server
    ' ls_ProposalPath contains the nearest path
    ' lo_ListOfPossibility contains all path where it must appear
    
    ls_req = ms_SearchReq
    ' Replace variable of the procedure, with value of each Filter
    For li_CursFilter = 1 To mi_OutlineFilterCount
        ls_req = ReplaceString(ls_req, li_CursFilter, ms_OutlineFilter(li_CursFilter), RT_Dollar)
    Next
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 1, ms_LanguageCode, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 2, prg.LoginName, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 3, ls_OutLineCode, RT_Dollar)
    
    If mb_FirstLevelInCombo Then
        If TypeName(mo_ViewCombo) = "Combobox" Then
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
        Else
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
        End If
        ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 4, lo_OutlineData.ls_ID, RT_Dollar)
    End If
    
    'ls_req = "EXEC Search_" & ms_ParamSystem & "_lst '" & ls_OutlineCode & "', '" & ms_LanguageCode & "', '" & prg.LoginName & "'"
    If mb_Use_NCS_ODBC = True Then
        lb_Result = NCS_Submit(ll_Statement, ls_req)
    Else
        lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
    End If
    If lb_Result = True Then
        li_Status = SQL_SUCCESS
    Else
        li_Status = SQL_ERROR
    End If

    Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        If mb_Use_NCS_ODBC = True Then
            li_Status = NCS_Fetch(ll_Statement)
        Else
            li_Status = SQLFetch(ll_Statement)
        End If
        If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
            If mb_Use_NCS_ODBC = True Then
                ls_path = NCS_GetData(ll_Statement, 1)
                ls_Desc = NCS_GetData(ll_Statement, 2)
            Else
                ls_path = ODBCData(ll_Statement, 1)
                ls_Desc = ODBCData(ll_Statement, 2)
            End If
            ReDim Preserve lo_ListOfPossibility(2, UBound(lo_ListOfPossibility, 2) + 1)
            li_CurrSoundLike = SoundLike(ls_ActualPath, ls_path)
            If li_ProposalSoundLike < li_CurrSoundLike Then
                li_ProposalSoundLike = li_CurrSoundLike
                ls_ProposalPath = ls_path
            End If
            If (li_ProposalSoundLike = li_CurrSoundLike And Len(ls_ProposalPath) > Len(ls_path)) Or (ls_ProposalPath = "") Or (ls_ProposalPath = "\") Then
                ls_ProposalPath = ls_path
            End If
            li_status1 = OK
            lo_ListOfPossibility(1, UBound(lo_ListOfPossibility, 2)) = ls_path
            lo_ListOfPossibility(2, UBound(lo_ListOfPossibility, 2)) = ls_Desc
        End If
    Loop

    If mb_Use_NCS_ODBC = True Then
        NCS_FreeStatement ll_Statement, SQL_DROP
    Else
        SQLFreeStatement ll_Statement, SQL_DROP
    End If



    'update the outline
    For li_Count = 1 To UBound(lo_ListOfPossibility, 2)
        If li_status1 = OK Then
            'If ((out_test.ListCount > 0) And (ls_path <> "")) Then
                TreeViewTryAddOnPath lo_ListOfPossibility(1, li_Count), ls_OutLineCode, lo_ListOfPossibility(2, li_Count)
            'End If
        End If
    Next
   
    TreeViewOpenPath ls_ProposalPath

End Sub



Public Sub UpdateComboView()
'------------------------------------------------------------------
' Name :UpdateComboView
'
'Purpose: Must be called by the combox that permit to change view (if there is one) when the view change.
'   It will change the view displayed in the outline.If a leaf had been selected, it will be selected in
'   the new view if it can be visible.
'
' review :  by JJB
'------------------------------------------------------------------
Dim lo_OutlineData As OutlineData
Dim ls_OldCode As String
    MouseOff
    'raiseevent EvtNodeClick (MCombo_GetCode(mo_ViewCombo),
    ls_OldCode = ms_LeafCode
    ms_LeafCode = ""
    TreeView1.Nodes.Clear
    If TypeName(mo_ViewCombo) = "ComboBox" Then
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
        RaiseEvent EvtNodeClick(lo_OutlineData.ls_ID, mo_ViewCombo.Text)
    Else
        If mo_ViewCombo.ListIndex = -1 Then Exit Sub
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
        RaiseEvent EvtNodeClick(lo_OutlineData.ls_ID, mo_ViewCombo.Desc)
    End If
    FillLevel Nothing, 2, "\" & lo_OutlineData.ls_ID, "\" & lo_OutlineData.ls_ViewCode, ""
    If ls_OldCode <> "" Then
        SearchLeaf ls_OldCode, "\" & lo_OutlineData.ls_ID
    End If
    
End Sub

Public Sub ClearLeafCode()
'------------------------------------------------------------------
' Name : ClearLeafCode
'
'Purpose: Must be called when you won't that the UpdateComboView
'   search the last leaf.
'
' review :  by AD
'------------------------------------------------------------------
    
    ms_LeafCode = ""
    
End Sub

Public Sub Clear()
'------------------------------------------------------------------
' Name : Clear
'
'Purpose: Clear the treeView.
'
' review :  by AD
'------------------------------------------------------------------
    
    TreeView1.Nodes.Clear
    
End Sub


Public Sub SearchLeaf(ByVal ls_OutLineCode As String, Optional ls_ForcedPath As Variant)
'------------------------------------------------------------------
' Name :SearchLeaf
'
' Purpose : Open the outline to show an item given by it's code with ls_OutLineCode
'           the outline try to open the outline the most closely where it already open
'
' param
'       ls_OutlineCode  : the code of the item to find
'       ls_ForecedPath : if set, oblige to find the item the nearest of the forced path
'
' review : 15/Mar/2000 by JJB
'------------------------------------------------------------------
Dim ls_req As String
Dim ls_path As String
Dim ls_ActualPath As String
Dim ls_ProposalPath As String
Dim li_CurrSoundLike As Integer
Dim li_ProposalSoundLike As Integer
Dim li_status1 As Integer
Dim li_Status As Integer
Dim ll_Statement As Long
Dim lo_OutlineData As OutlineData
Dim lb_Result As Boolean

Dim li_CursFilter As Integer
    'init some variable
    li_status1 = KO
    'ls_ActualPath = out_Test2.FullPath(out_test.ListIndex)
    
    If IsMissing(ls_ForcedPath) Then
        ls_ActualPath = TreeViewGetPath(TreeView1.SelectedItem)
    Else
        ls_ActualPath = ls_ForcedPath
    End If
       
    ls_ProposalPath = ""
    li_ProposalSoundLike = 0
    
    ls_req = ms_SearchReq
    ' Replace variable of the procedure, with value of each Filter
    For li_CursFilter = 1 To mi_OutlineFilterCount
        ls_req = ReplaceString(ls_req, li_CursFilter, ms_OutlineFilter(li_CursFilter), RT_Dollar)
    Next
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 1, ms_LanguageCode, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 2, prg.LoginName, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 3, ls_OutLineCode, RT_Dollar)
    
    If mb_FirstLevelInCombo Then
        If TypeName(mo_ViewCombo) = "ComboBox" Then
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
        Else
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
        End If
        ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 4, lo_OutlineData.ls_ID, RT_Dollar)
    End If
    
    If mb_Use_NCS_ODBC = True Then
        lb_Result = NCS_Submit(ll_Statement, ls_req)
    Else
        lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
    End If
    If lb_Result = True Then
        li_Status = SQL_SUCCESS
    Else
        li_Status = SQL_ERROR
    End If
    
    ' search for the item the closest to the actual path
    Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        If mb_Use_NCS_ODBC = True Then
            li_Status = NCS_Fetch(ll_Statement)
        Else
            li_Status = SQLFetch(ll_Statement)
        End If
        If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
            If mb_Use_NCS_ODBC = True Then
                ls_path = NCS_GetData(ll_Statement, 1)
            Else
                ls_path = ODBCData(ll_Statement, 1)
            End If
            li_CurrSoundLike = SoundLike(ls_ActualPath, ls_path)
            If li_ProposalSoundLike < li_CurrSoundLike Then
                li_ProposalSoundLike = li_CurrSoundLike
                ls_ProposalPath = ls_path
            End If
            If (li_ProposalSoundLike = li_CurrSoundLike And Len(ls_ProposalPath) > Len(ls_path)) Or (ls_ProposalPath = "") Or (ls_ProposalPath = "\") Then
                ls_ProposalPath = ls_path
            End If
            li_status1 = OK
        End If
    Loop
    If li_Status = SQL_ERROR Then
        SendMessage 93, "Item code does not exist !", gut_LangLogin.Code, , , mb_Use_NCS_ODBC
    End If
    If mb_Use_NCS_ODBC = True Then
        NCS_FreeStatement ll_Statement, SQL_DROP
    Else
        SQLFreeStatement ll_Statement, SQL_DROP
    End If
    
    TreeViewOpenPath ls_ProposalPath
    
End Sub






















'------------------------------------------------------------------
'------------------------------------------------------------------
' Private Sub & Function Part
'------------------------------------------------------------------
'------------------------------------------------------------------

Private Sub TreeView1_DblClick()
    If mb_OnNodeClick Then
        mb_DblClickFired = OK
    Else
        RaiseEvent DblClick
        mb_DblClickFired = KO
    End If
End Sub

Private Sub TreeView1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If TypeName(TreeView1.HitTest(x, y)) <> "Nothing" Then
        TreeView1.ToolTipText = TreeView1.HitTest(x, y).Text
    Else
        TreeView1.ToolTipText = ""
    End If
End Sub

Private Sub TreeView1_NodeClick(ByVal Node As MSComctlLib.Node)
Dim lo_OutlineData As OutlineData
    mb_OnNodeClick = OK
    MouseOff
    ms_LeafCode = ""
    Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(TreeView1.SelectedItem.Key)
    If lo_OutlineData.lb_TerminalData Then
        ms_LeafCode = lo_OutlineData.ls_ID
        RaiseEvent EvtLeafClick(ms_LeafCode, TreeView1.SelectedItem.Text)
    Else
        If TreeView1.SelectedItem.children = 0 Then
            FillLevel TreeView1.SelectedItem, TreeViewGetHeight(TreeView1.SelectedItem) + 1, TreeViewGetPath(TreeView1.SelectedItem), TreeViewGetView(TreeView1.SelectedItem), ""
        End If
        RaiseEvent EvtNodeClick(lo_OutlineData.ls_ID, TreeView1.SelectedItem.Text)
    End If
    MouseOn
    mb_OnNodeClick = KO
    If mb_DblClickFired Then TreeView1_DblClick
End Sub

Private Sub UserControl_Initialize()
'------------------------------------------------------------------
' Name :UserControl_Initialize
'
' Purpose : Initialise the control
'           By default the CTreeView don't use a combo box to change the view
'           And by default the CTreeView use no Filter
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    ml_Key = 0
    mb_FirstLevelInCombo = KO
    mi_OutlineFilterCount = 0
    mb_LeafStringData = OK
    mb_OnNodeClick = KO
    mb_DblClickFired = KO
    ms_DefaultComboView = ""
    mb_Use_NCS_ODBC = False
End Sub

Public Property Get Font() As StdFont
  
  Set Font = TreeView1.Font

End Property

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    TreeView1.ToolTipText = PropBag.ReadProperty("ToolTipText", "")
End Sub

Private Sub UserControl_Resize()
'------------------------------------------------------------------
' Name :UserControl_Resize
'
' Purpose : Resize the Treeview to CTreeView extend
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

    TreeView1.Height = Height
    TreeView1.Width = Width
    TreeView1.Top = 0
    TreeView1.Left = 0
    RaiseEvent Resize
End Sub


Private Function GetIDStoredProcedure(ByVal li_level As Integer, ByVal ls_View As String) As Integer
'------------------------------------------------------------------
' Name :GetIDStoredProcedure
'
' Purpose :
'
' Param :   li_Level      :
'           lo_Picture  :
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

Dim i As Integer
    GetIDStoredProcedure = 0
    For i = 1 To UBound(ms_OutlineParameter, 2)
        If li_level = 1 Then
            If CInt(ms_OutlineParameter(1, i)) = li_level And (ms_OutlineParameter(2, i)) = ls_View Then
                GetIDStoredProcedure = i
                Exit Function
            End If
        Else
            If CInt(ms_OutlineParameter(1, i)) = li_level And (ms_OutlineParameter(2, i)) = ls_View Then
                GetIDStoredProcedure = i
                Exit Function
            End If
        End If
    Next i
End Function

Private Sub FillLevel(ByRef lo_SelectedNode As Node, ByVal li_level As Integer, ByVal ls_path As String, ByVal ls_View As String, ByVal as_codeToSelect As String)
'------------------------------------------------------------------
' Name :FillLevel
'
' Purpose : fill a specified level of the outline
'
' param :
'   lo_SelectedNode : the actually selected node
'   li_Level        : the level to fill
'   ls_path         : the actual path
'   ls_View         : the actual view
'
' review : 15/Mars/2000 by JJB
'------------------------------------------------------------------

Dim ls_req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim lo_InsertedNode As Node
Dim ls_Code As String
Dim ls_Desc As String
Dim li_pos As Integer
Dim lo_OutlineData As OutlineData
Dim ls_TempView As String
Dim i As Integer
Dim li_var As Integer
Dim ls_var As String
Dim ls_NewKey As String
Dim li_CursFilter As Integer
Dim lb_Result As Boolean

li_pos = GetIDStoredProcedure(li_level, ls_View)

ls_req = ms_OutlineParameter(3, li_pos)

If ls_req = "" Then
    MouseOn
    Exit Sub
End If


' Replace variable of the procedure, with value of each Filter
For li_CursFilter = 1 To mi_OutlineFilterCount
    ls_req = ReplaceString(ls_req, li_CursFilter, ms_OutlineFilter(li_CursFilter), RT_Dollar)
Next

ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 1, ms_LanguageCode, RT_Dollar)

ls_req = ReplaceString(ls_req, mi_OutlineFilterCount + 2, prg.LoginName, RT_Dollar)


For li_var = 1 To (li_level - 1)
    ls_var = PathPart(ls_path, li_var)
    ls_req = ReplaceString(ls_req, li_var + mi_OutlineFilterCount + 2, ls_var, RT_Dollar)
Next li_var


'Run the stored procedure to obtain data
If mb_Use_NCS_ODBC = True Then
    lb_Result = NCS_Submit(ll_Statement, ls_req)
Else
    lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
End If

If lb_Result = True Then
   li_Status = SQL_SUCCESS
Else
   li_Status = SQL_ERROR
End If

' Check the number of records and load them into temp array for later iteration JN 25/04/2019
Dim la_data() As dataItem
Dim ll_Idx As Long
Dim ll_codeFound As Long

ll_codeFound = -1

ReDim la_data(0) As dataItem

ll_Idx = 0
Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO

    If mb_Use_NCS_ODBC = True Then
        li_Status = NCS_Fetch(ll_Statement)
    Else
        li_Status = SQLFetch(ll_Statement)
    End If
    
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        
        If ll_Idx > UBound(la_data) Then
            ReDim Preserve la_data(ll_Idx + 100) As dataItem
        End If
        
        If mb_Use_NCS_ODBC = True Then
            la_data(ll_Idx).Code = NCS_GetData(ll_Statement, 1)
            la_data(ll_Idx).Desc = NCS_GetData(ll_Statement, 2)
        Else
            la_data(ll_Idx).Code = ODBCData(ll_Statement, 1)
            la_data(ll_Idx).Desc = ODBCData(ll_Statement, 2)
        End If
        
        If la_data(ll_Idx).Code = as_codeToSelect Then
            ll_codeFound = ll_Idx
        End If
        
        ll_Idx = ll_Idx + 1
    End If

Loop

Dim ll_RowCount As Long
ll_RowCount = ll_Idx

If mb_Use_NCS_ODBC = True Then
    NCS_FreeStatement ll_Statement, SQL_DROP
Else
    SQLFreeStatement ll_Statement, SQL_DROP
End If

If ll_RowCount > 5000 Then
    ' show message that nb of records is big
    ReDim ms_MsgInfo(0, 1)
    ms_MsgInfo(0, 0) = "$ITEMS$"
    ms_MsgInfo(0, 1) = ll_RowCount
    
    If SendMessage(92, "Loading $ITEMS$ items will take some time. Do you want to continue loading complete set?", gut_LangLogin.Code, vbYesNo, , mb_Use_NCS_ODBC, ms_MsgInfo) = vbNo Then
        ' only one record to load ( the one we search for )
        If ll_codeFound = -1 Then
            ll_RowCount = 1000              ' load only first 1000 records
        Else
            ll_RowCount = 1000                 ' load only first 1000 + the one we search
            If ll_codeFound > ll_RowCount Then
                la_data(ll_RowCount).Code = la_data(ll_codeFound).Code
                la_data(ll_RowCount).Desc = la_data(ll_codeFound).Desc
                ll_RowCount = ll_RowCount + 1
            End If
        End If
        
    End If
    
End If

For ll_Idx = LBound(la_data) To ll_RowCount - 1
        
        ls_Code = la_data(ll_Idx).Code
        ls_Desc = la_data(ll_Idx).Desc
        
        If li_level = 1 And mb_FirstLevelInCombo Then
            'no support for directory data
            ls_NewKey = TreeViewGetNewKey()
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                MCombo_AddItemCode mo_ViewCombo, ls_NewKey, ls_Desc, KO
                If mo_ViewCombo.columnCount < 2 Then
                    mo_ViewCombo.columnCount = 2
                    mo_ViewCombo.ColumnWidths = "-1;0;0"
                End If
                mo_ViewCombo.Column(2, mo_ViewCombo.ListCount - 1) = ls_Code
            Else
                mo_ViewCombo.AddItem KO, ls_NewKey, ls_Desc
                If mo_ViewCombo.columnCount = 0 Then
                    mo_ViewCombo.columnCount = 1
                    mo_ViewCombo.columnWidth(0) = 0
                End If
                mo_ViewCombo.Column(0, mo_ViewCombo.ListCount - 1) = ls_Code
            End If
            Set lo_OutlineData = New OutlineData
                                        
            lo_OutlineData.ls_ID = ls_Code
            lo_OutlineData.lb_TerminalData = KO
            lo_OutlineData.lb_TerminalDirectoryData = KO
            
            If ms_OutlineParameter(4, li_pos) = "Y" Then 'if the level is a view
                lo_OutlineData.ls_ViewCode = ls_Code
            Else
                lo_OutlineData.ls_ViewCode = ""
            End If
            If ms_OutlineParameter(5, li_pos) = "Y" Then 'if it's terminal
                'lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                lo_OutlineData.lb_TerminalData = OK
            Else
                'lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                lo_OutlineData.lb_TerminalData = KO
            End If
            mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
            
        ElseIf li_level = 1 And Not (mb_FirstLevelInCombo) Then
            If ms_OutlineParameter(6, li_pos) = "Y" Then ' if it's directory data
                TreeViewAddPath TreeView1, lo_SelectedNode, ls_Code, ls_Desc
            Else
                ls_NewKey = TreeViewGetNewKey()
                Set lo_InsertedNode = TreeView1.Nodes.Add(, , ls_NewKey, ls_Desc)
                
                If ms_OutlineParameter(8, li_pos) = "Asc" Then TreeView1.Sorted = OK

                Set lo_OutlineData = New OutlineData
                                        
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalData = KO
                lo_OutlineData.lb_TerminalDirectoryData = KO
                
                If ms_OutlineParameter(4, li_pos) = "Y" Then 'if the level is a view
                    lo_OutlineData.ls_ViewCode = ls_Code
                Else
                    lo_OutlineData.ls_ViewCode = ""
                End If
                If ms_OutlineParameter(5, li_pos) = "Y" Then 'if it's terminal
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                    lo_OutlineData.lb_TerminalData = OK
                Else
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                    lo_OutlineData.lb_TerminalData = KO
                End If
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
            End If
        ElseIf li_level > 2 Or (li_level = 2 And Not (mb_FirstLevelInCombo)) Then
            If ms_OutlineParameter(6, li_pos) = "Y" Then ' if it's directory data
                TreeViewAddPath TreeView1, lo_SelectedNode, ls_Code, ls_Desc
            Else
                ls_NewKey = TreeViewGetNewKey()
                Set lo_InsertedNode = TreeView1.Nodes.Add(lo_SelectedNode, tvwChild, ls_NewKey, ls_Desc)
                
                If ms_OutlineParameter(8, li_pos) = "Asc" Then lo_SelectedNode.Sorted = OK
                
                Set lo_OutlineData = New OutlineData
                                        
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalData = KO
                lo_OutlineData.lb_TerminalDirectoryData = KO
                
                If ms_OutlineParameter(4, li_pos) = "Y" Then 'if the level is a view
                    lo_OutlineData.ls_ViewCode = ls_Code
                Else
                    lo_OutlineData.ls_ViewCode = ""
                End If
                If ms_OutlineParameter(5, li_pos) = "Y" Then 'if it's terminal
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                    lo_OutlineData.lb_TerminalData = OK
                Else
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                    lo_OutlineData.lb_TerminalData = KO
                End If
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
            End If
        ElseIf li_level = 2 And mb_FirstLevelInCombo Then
            If ms_OutlineParameter(6, li_pos) = "Y" Then ' if it's directory data
                TreeViewAddPath TreeView1, Nothing, ls_Code, ls_Desc
            Else
                ls_NewKey = TreeViewGetNewKey()
                Set lo_InsertedNode = TreeView1.Nodes.Add(, , ls_NewKey, ls_Desc)
                
                If ms_OutlineParameter(8, li_pos) = "Asc" Then TreeView1.Sorted = OK
                
                Set lo_OutlineData = New OutlineData
                                        
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalData = KO
                lo_OutlineData.lb_TerminalDirectoryData = KO
                
                If ms_OutlineParameter(4, li_pos) = "Y" Then 'if the level is a view
                    lo_OutlineData.ls_ViewCode = ls_Code
                Else
                    lo_OutlineData.ls_ViewCode = ""
                End If
                If ms_OutlineParameter(5, li_pos) = "Y" Then 'if it's terminal
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                    lo_OutlineData.lb_TerminalData = OK
                Else
                    lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                    lo_OutlineData.lb_TerminalData = KO
                End If
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
            End If
        End If

Next

MouseOn
Exit Sub

suite:
MouseOn
If mb_Use_NCS_ODBC = True Then
    NCS_FreeStatement ll_Statement, SQL_DROP
Else
    SQLFreeStatement ll_Statement, SQL_DROP
End If
StdError
End Sub

Private Sub GetOutlineParameter()
'------------------------------------------------------------------
' Name : GetOutlineParameter
'
' Purpose : Get all stored procedure for filling the outline
'           it fill ms_OutlineParameter depending of the system (ms_ParamSystem)
'
' Parameters : None
'
' review : 27/Oct/1999 by JJB
'------------------------------------------------------------------

Dim ls_req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ls_Field As String, ls_Text As String
Dim lb_Result As Boolean

On Error GoTo suite

ReDim ms_OutlineParameter(8, 0)

ls_req = "EXEC OutlineParameter3_lst '" & ms_ParamSystem & "', '" & ms_LanguageCode & "'"

If mb_Use_NCS_ODBC = True Then
    lb_Result = NCS_Submit(ll_Statement, ls_req)
Else
    lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
End If

If lb_Result = True Then
    li_Status = SQL_SUCCESS
Else
    li_Status = SQL_ERROR
End If

Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
    If mb_Use_NCS_ODBC = True Then
        li_Status = NCS_Fetch(ll_Statement)
    Else
        li_Status = SQLFetch(ll_Statement)
    End If
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then

        ReDim Preserve ms_OutlineParameter(8, UBound(ms_OutlineParameter, 2) + 1)
        
        If mb_Use_NCS_ODBC = True Then
            'level
            ms_OutlineParameter(1, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 1)
            'view
            ms_OutlineParameter(2, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 2)
            'req
            ms_OutlineParameter(3, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 3)
            'isView
            ms_OutlineParameter(4, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 4)
            'isTerminal
            ms_OutlineParameter(5, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 5)
            'isDirectoryChild
            ms_OutlineParameter(6, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 6)
            'req fo nodes
            ms_OutlineParameter(7, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 7)
            'type of order used
            ms_OutlineParameter(8, UBound(ms_OutlineParameter, 2)) = NCS_GetData(ll_Statement, 8)
        Else
            'level
            ms_OutlineParameter(1, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 1)
            'view
            ms_OutlineParameter(2, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 2)
            'req
            ms_OutlineParameter(3, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 3)
            'isView
            ms_OutlineParameter(4, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 4)
            'isTerminal
            ms_OutlineParameter(5, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 5)
            'isDirectoryChild
            ms_OutlineParameter(6, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 6)
            'req fo nodes
            ms_OutlineParameter(7, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 7)
            'type of order used
            ms_OutlineParameter(8, UBound(ms_OutlineParameter, 2)) = ODBCData(ll_Statement, 8)
        End If
    End If
Loop
If mb_Use_NCS_ODBC = True Then
    NCS_FreeStatement ll_Statement, SQL_DROP
Else
    SQLFreeStatement ll_Statement, SQL_DROP
End If
Exit Sub

suite:
If mb_Use_NCS_ODBC = True Then
    NCS_FreeStatement ll_Statement, SQL_DROP
Else
    SQLFreeStatement ll_Statement, SQL_DROP
End If
StdError
End Sub

Public Function IsLastNode() As Boolean
Dim li_Position As Integer
Dim ls_View As String
Dim i As Integer
Dim li_PositionSlash As Integer

    On Error GoTo isLastNode_Err

    IsLastNode = False

    ls_View = TreeViewGetView(TreeView1.SelectedItem)
    li_Position = TreeViewGetHeight(TreeView1.SelectedItem) + 1
    
    i = 1
    Do While i <= UBound(ms_OutlineParameter, 2)
        If li_Position = ms_OutlineParameter(1, i) And LCase(Trim(ls_View)) = LCase(Trim(ms_OutlineParameter(2, i))) Then
            Exit Function
        End If
        i = i + 1
    Loop
        
    IsLastNode = True
    
isLastNode_Err:

End Function

Private Function PathPart(ls_path As String, li_Number As Integer) As String
'------------------------------------------------------------------
' Name :PathPart
'
' Purpose :return a specified level of a path
'
' param : ls_Path : a path like "\level1\level2"
'         li_number : extract a specific level (the first level is 1)
'
'
' review : 27/Nov/1999 by JJB
'------------------------------------------------------------------


' Return the part of the path of an item in an Outline
' at the a_Number level (separator = \)
Dim li_Count As Integer
Dim li_Last As Integer
Dim li_Next As Integer

li_Count = 0
li_Last = 0
li_Next = 1
Do While li_Number > li_Count
    li_Last = li_Next
    li_Next = InStr(li_Last + 1, ls_path, "\")
    li_Count = li_Count + 1
    If li_Next = 0 Then
        li_Next = Len(ls_path) + 1
        Exit Do
    End If
Loop
If li_Count = li_Number Then
    PathPart = Mid(ls_path, li_Last + 1, li_Next - li_Last - 1)
End If

End Function

Private Function TreeViewGetNewKey() As String
'------------------------------------------------------------------
' Name :TreeViewGetNewKey
'
' Purpose :return a new unique key for a new treeview node
'          the new key is return as a string like "TX" where X is a number
'          the first number is 1
'
'
'
' review : 15/Mar/2000 by JJB
'------------------------------------------------------------------

    ml_Key = ml_Key + 1
    TreeViewGetNewKey = "T" & CStr(ml_Key)
End Function


Private Sub TreeViewAddPath(ByRef lo_TreeView As TreeView, ByRef lo_BaseNode As Node, ByVal ls_IDPath As String, ByVal ls_path As String)
Dim lo_ReferenceNode As Node
Dim la_ElementsArray() As String
Dim li_CursElements  As Integer
Dim lo_TempElement As Node
Dim lo_OutlineData As OutlineData
Dim ls_NewKey As String

    la_ElementsArray = SplitString(ls_path, "\")
    For li_CursElements = 0 To UBound(la_ElementsArray)
        If li_CursElements = 0 Then
            If TypeName(lo_BaseNode) = "Nothing" Then
                Set lo_TempElement = TreeViewFindElement(lo_TreeView.Nodes, 0, la_ElementsArray(li_CursElements))
                If TypeName(lo_TempElement) = "Nothing" Then
                    ls_NewKey = TreeViewGetNewKey()
                    Set lo_ReferenceNode = lo_TreeView.Nodes.Add(, , ls_NewKey, la_ElementsArray(li_CursElements))
                    lo_ReferenceNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                    Set lo_OutlineData = New OutlineData
                    lo_OutlineData.lb_DirectoryData = OK
                    lo_OutlineData.lb_TerminalData = KO
                    If li_CursElements = UBound(la_ElementsArray) Then
                        lo_OutlineData.lb_TerminalDirectoryData = OK
                        lo_OutlineData.ls_ID = ls_IDPath
                    Else
                        lo_OutlineData.lb_TerminalDirectoryData = KO
                        lo_OutlineData.ls_ID = ""
                    End If
                    lo_OutlineData.ls_ViewCode = ""
                    mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                Else
                    Set lo_ReferenceNode = lo_TempElement
                End If
            Else
                Set lo_TempElement = TreeViewFindElement(lo_TreeView.Nodes, lo_BaseNode.Index, la_ElementsArray(li_CursElements))
                If TypeName(lo_TempElement) = "Nothing" Then
                    ls_NewKey = TreeViewGetNewKey()
                    Set lo_ReferenceNode = lo_TreeView.Nodes.Add(lo_BaseNode, tvwChild, ls_NewKey, la_ElementsArray(li_CursElements))
                    lo_ReferenceNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                    Set lo_OutlineData = New OutlineData
                    lo_OutlineData.lb_DirectoryData = OK
                    lo_OutlineData.lb_TerminalData = KO
                    If li_CursElements = UBound(la_ElementsArray) Then
                        lo_OutlineData.lb_TerminalDirectoryData = OK
                        lo_OutlineData.ls_ID = ls_IDPath
                    Else
                        lo_OutlineData.lb_TerminalDirectoryData = KO
                        lo_OutlineData.ls_ID = ""
                    End If
                    lo_OutlineData.ls_ViewCode = ""
                    mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                Else
                    Set lo_ReferenceNode = lo_TempElement
                End If
            End If
        Else
            Set lo_TempElement = TreeViewFindElement(lo_TreeView.Nodes, lo_ReferenceNode.Index, la_ElementsArray(li_CursElements))
            If TypeName(lo_TempElement) = "Nothing" Then
                ls_NewKey = TreeViewGetNewKey()
                Set lo_ReferenceNode = lo_TreeView.Nodes.Add(lo_ReferenceNode.Index, tvwChild, ls_NewKey, la_ElementsArray(li_CursElements))
                lo_ReferenceNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                Set lo_OutlineData = New OutlineData
                lo_OutlineData.lb_DirectoryData = OK
                lo_OutlineData.lb_TerminalData = KO
                If li_CursElements = UBound(la_ElementsArray) Then
                    lo_OutlineData.lb_TerminalDirectoryData = OK
                    lo_OutlineData.ls_ID = ls_IDPath
                Else
                    lo_OutlineData.lb_TerminalDirectoryData = KO
                    lo_OutlineData.ls_ID = ""
                End If
                lo_OutlineData.ls_ViewCode = ""
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
            Else
                Set lo_ReferenceNode = lo_TempElement
            End If
        End If
    Next
End Sub


Private Function TreeViewFindElement(ByRef lo_Tree As Nodes, ByVal li_Racine As Integer, ByVal ls_Decription As String) As Node
On Error GoTo Err_TreeViewFindElement
Dim li_CursNode As Integer
Dim lo_parentNode As Node
    
    'scan all nodes
    For li_CursNode = 1 To lo_Tree.Count
        ' that have the racine as parent
        Set lo_parentNode = lo_Tree.Item(li_CursNode).Parent
        If li_Racine = 0 Then
            'element that have no parent
            If TypeName(lo_parentNode) = "Nothing" Then
                'if the description is equal, we've found it
                If lo_Tree.Item(li_CursNode).Text = ls_Decription Then
                    Set TreeViewFindElement = lo_Tree.Item(li_CursNode)
                    Exit Function
                End If
            End If
        Else
            If TypeName(lo_parentNode) <> "Nothing" Then
                If lo_parentNode.Index = li_Racine Then
                    'if the description is equal, we've found it
                    If lo_Tree.Item(li_CursNode).Text = ls_Decription Then
                        Set TreeViewFindElement = lo_Tree.Item(li_CursNode)
                        Exit Function
                    End If
                End If
            End If
        End If
    Next
    
    Set TreeViewFindElement = Nothing
    Exit Function
    
Err_TreeViewFindElement:
    Set TreeViewFindElement = Nothing
End Function




Private Function TreeViewGetHeight(ByRef lo_Node As Node) As Integer
'------------------------------------------------------------------
' Name :TreeViewGetHeight
'
' Purpose :return the level of the node (it takes account of the combo box to change the view, if it is used)
'          the first level is 1
'          on error it returns 0
'
' Param :   lo_Node :   the node to compute the level
'
' review : 15/Mar/2000 by JJB
'------------------------------------------------------------------

On Error GoTo Err_TreeViewGetHeight
Dim lo_parentNode As Node
Dim lo_OutlineData As OutlineData
Dim li_ComboLevel As Integer
    TreeViewGetHeight = 0
    If TypeName(lo_Node) = "Nothing" Then
        If mb_FirstLevelInCombo Then
            TreeViewGetHeight = 1
        Else
            TreeViewGetHeight = 0
        End If
        Exit Function
    End If
    Set lo_parentNode = lo_Node.Parent
    If TypeName(lo_parentNode) = "Nothing" Then
        If mb_FirstLevelInCombo Then
            li_ComboLevel = 1
        Else
            li_ComboLevel = 0
        End If
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetHeight = 1 + li_ComboLevel
            Else
                TreeViewGetHeight = 0 + li_ComboLevel
            End If
        Else
            TreeViewGetHeight = 1 + li_ComboLevel
        End If
    Else
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetHeight = 1 + TreeViewGetHeight(lo_parentNode)
            Else
                TreeViewGetHeight = TreeViewGetHeight(lo_parentNode)
            End If
        Else
            TreeViewGetHeight = 1 + TreeViewGetHeight(lo_parentNode)
        End If
    End If
    Exit Function
    
Err_TreeViewGetHeight:

End Function

Private Function TreeViewGetView(ByRef lo_Node As Node) As String
'------------------------------------------------------------------
' Name :TreeViewGetHeight
'
' Purpose :return the absolute View of a node as a Path like "\View1\View2"
'          on error it returns ""
'          the function takes into account of the combo box if used
'
' Param :   lo_Node :   the node to compute the absolute View
'
' review : 15/Mar/2000 by JJB
'------------------------------------------------------------------

On Error GoTo Err_TreeViewGetView
Dim lo_parentNode As Node
Dim lo_OutlineData As OutlineData
Dim ls_ParentView As String
Dim ls_ComboView As String

    TreeViewGetView = ""
    If TypeName(lo_Node) = "Nothing" Then
        If mb_FirstLevelInCombo Then
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
            Else
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
            End If
            TreeViewGetView = "\" & lo_OutlineData.ls_ViewCode
        Else
            TreeViewGetView = ""
        End If
        Exit Function
    End If
    Set lo_parentNode = lo_Node.Parent
    If TypeName(lo_parentNode) = "Nothing" Then
        If mb_FirstLevelInCombo Then
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
            Else
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
            End If
            ls_ComboView = "\" & lo_OutlineData.ls_ViewCode
        Else
            ls_ComboView = ""
        End If
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetView = ls_ComboView & "\" & lo_OutlineData.ls_ViewCode
            Else
                TreeViewGetView = ls_ComboView
            End If
        Else
            TreeViewGetView = ls_ComboView & "\" & lo_OutlineData.ls_ViewCode
        End If
    Else
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetView = TreeViewGetView(lo_parentNode) & "\" & lo_OutlineData.ls_ViewCode
            Else
                TreeViewGetView = TreeViewGetView(lo_parentNode)
            End If
        Else
            TreeViewGetView = TreeViewGetView(lo_parentNode) & "\" & lo_OutlineData.ls_ViewCode
        End If
    End If
    Exit Function
    
Err_TreeViewGetView:
End Function


Private Function TreeViewGetPath(ByRef lo_Node As Node) As String
'------------------------------------------------------------------
' Name :TreeViewGetHeight
'
' Purpose :return the absolute path of a node as a Path like "\directory1\Directory2"
'          on error it returns ""
'          the function takes into account of the combo box if used
'
' Param :   lo_Node :   the node to compute the absolute path
'
' review : 15/Mar/2000 by JJB
'------------------------------------------------------------------

On Error GoTo Err_TreeViewGetPath
Dim lo_parentNode As Node
Dim lo_OutlineData As OutlineData
Dim ls_ParentNode As String
Dim ls_ComboPath As String

    If mb_FirstLevelInCombo Then 'we count the path of the combo
        If TypeName(mo_ViewCombo) = "ComboBox" Then
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
        Else
            Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
        End If
        
        TreeViewGetPath = "\" & lo_OutlineData.ls_ID
    Else
        TreeViewGetPath = ""
    End If
    
    Set lo_parentNode = lo_Node.Parent
    If TypeName(lo_parentNode) = "Nothing" Then
        If mb_FirstLevelInCombo Then
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
            Else
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
            End If
            ls_ComboPath = "\" & lo_OutlineData.ls_ID
        Else
            ls_ComboPath = ""
        End If
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetPath = ls_ComboPath & "\" & lo_OutlineData.ls_ID
            Else
                TreeViewGetPath = ls_ComboPath & ""
            End If
        Else
            TreeViewGetPath = ls_ComboPath & "\" & lo_OutlineData.ls_ID
        End If
    Else
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_Node.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            If lo_OutlineData.lb_TerminalDirectoryData = OK Then
                TreeViewGetPath = TreeViewGetPath(lo_parentNode) & "\" & lo_OutlineData.ls_ID
            Else
                TreeViewGetPath = TreeViewGetPath(lo_parentNode)
            End If
        Else
            TreeViewGetPath = TreeViewGetPath(lo_parentNode) & "\" & lo_OutlineData.ls_ID
        End If
    End If
    Exit Function
    
Err_TreeViewGetPath:

End Function


'Public Property Get ToolTipText() As String
'    'Return the actual tip text in the TreeView
'    ToolTipText = TreeView1.ToolTipText
'End Property
'
'
'Public Property Let ToolTipText(ByVal New_ToolTipText As String)
'    'Change the actual tip text in the TreeView
'    TreeView1.ToolTipText() = New_ToolTipText
'    PropertyChanged "ToolTipText"
'End Property

Private Function GetSGBDNodeDescription(ByVal li_pos As Integer, ByVal ls_OutLineCode As String) As String
On Error GoTo Err_GetSGBDNodeDescription
Dim ls_req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim ls_Desc As String
Dim lb_Result As Boolean

    GetSGBDNodeDescription = ""
    ls_req = ms_OutlineParameter(7, li_pos)
    If ls_req = "" Then
        Exit Function
    End If
    
    ls_req = ReplaceString(ls_req, 1, ms_LanguageCode, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, 2, ls_OutLineCode, RT_Dollar)
    
    ls_req = ReplaceString(ls_req, 3, prg.LoginName, RT_Dollar)
    
    If mb_Use_NCS_ODBC = True Then
        lb_Result = NCS_Submit(ll_Statement, ls_req)
    Else
        lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
    End If
    If lb_Result = True Then
        li_Status = SQL_SUCCESS
    Else
        li_Status = SQL_ERROR
    End If
    
    ' search for the item the closest to the actual path
    Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        If mb_Use_NCS_ODBC = True Then
            li_Status = NCS_Fetch(ll_Statement)
        Else
            li_Status = SQLFetch(ll_Statement)
        End If
        If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
            If mb_Use_NCS_ODBC = True Then
                ls_Desc = NCS_GetData(ll_Statement, 1)
            Else
                ls_Desc = ODBCData(ll_Statement, 1)
            End If
            GetSGBDNodeDescription = ls_Desc
        End If
    Loop
    If mb_Use_NCS_ODBC = True Then
        NCS_FreeStatement ll_Statement, SQL_DROP
    Else
        SQLFreeStatement ll_Statement, SQL_DROP
    End If
    Exit Function
    
Err_GetSGBDNodeDescription:
    If mb_Use_NCS_ODBC = True Then
        NCS_FreeStatement ll_Statement, SQL_DROP
    Else
        SQLFreeStatement ll_Statement, SQL_DROP
    End If
End Function


Private Sub TreeViewOpenPath(ByVal ls_path As String, Optional lb_Forced As Boolean, Optional lb_NoEvents As Boolean = False)
'------------------------------------------------------------------
' Name :TreeViewOpenPath
'
' Purpose :
'
' Param :   ls_path :
'           lb_Forced :
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

Dim la_ElementsArray() As String
Dim li_CursElements  As Integer
'Dim lo_TempElement As Node
Dim lo_ReferenceNode As Node
Dim lo_OldReferenceNode As Node
Dim lo_InsertedNode  As Node
Dim lo_OutlineData As OutlineData
Dim li_FirstTreeLevel As Integer
Dim ls_Key As String
Dim lo_InsertOutlineData As New OutlineData
Dim li_pos As Integer
Dim li_OldReferenceNodeHeight As Integer
Dim ls_OldReferenceNodeView As String
Dim li_CursComboItem As Integer
Dim lb_ComboFind As Boolean
Dim ls_ComboCode As String
Dim ls_Desc As String

    If ls_path = "" Then Exit Sub
    ms_LeafCode = ""
    la_ElementsArray = SplitString(ls_path, "\")
    If mb_FirstLevelInCombo Then
        li_FirstTreeLevel = 2
        ' test if a view is selected
        If mo_ViewCombo.ListIndex = -1 Then
            lb_ComboFind = KO
            'we must selected the correct item in the combo
            For li_CursComboItem = 0 To mo_ViewCombo.ListCount - 1
                If TypeName(mo_ViewCombo) = "ComboBox" Then
                    ls_ComboCode = mo_ViewCombo.Column(1, li_CursComboItem)
                Else
                    ls_ComboCode = mo_ViewCombo.Code(li_CursComboItem)
                End If
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(ls_ComboCode)
                If la_ElementsArray(1) = lo_OutlineData.ls_ID Then
                    lb_ComboFind = OK
                    Exit For
                End If
            Next
            
            If lb_ComboFind Then
                If TypeName(mo_ViewCombo) = "ComboBox" Then
                    MCombo_CodeSelect(mo_ViewCombo) = ls_ComboCode
                Else
                    mo_ViewCombo.CodeSelect = ls_ComboCode
                End If
            Else
                Exit Sub
            End If
        Else 'so, a view is already selected
            ' we check if the view selected in the combo is the good one
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
            Else
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
            End If
            If Not (la_ElementsArray(1) = lo_OutlineData.ls_ID) Then
                'we must selected the correct item in the combo
                lb_ComboFind = KO
                'we must selected the correct item in the combo
                For li_CursComboItem = 0 To mo_ViewCombo.ListCount - 1
                    If TypeName(mo_ViewCombo) = "ComboBox" Then
                        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
                    Else
                        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
                    End If
                    If la_ElementsArray(1) = lo_OutlineData.ls_ID Then
                        lb_ComboFind = OK
                        Exit For
                    End If
                Next
                
                If lb_ComboFind Then
                    If TypeName(mo_ViewCombo) = "ComboBox" Then
                        MCombo_CodeSelect(mo_ViewCombo) = ls_ComboCode
                    Else
                        mo_ViewCombo.CodeSelect = ls_ComboCode
                    End If
                Else
                    Exit Sub
                End If
            End If
        End If
    Else 'so, the first level is not in a combobox
        li_FirstTreeLevel = 1
    End If
    
    
    
    'open the tree nodes after nodes
    For li_CursElements = li_FirstTreeLevel To UBound(la_ElementsArray)
        If li_CursElements = li_FirstTreeLevel Then
            Set lo_ReferenceNode = TreeViewFindChildElementByCode(TreeView1, Nothing, Trim(la_ElementsArray(li_CursElements)))
            If TypeName(lo_ReferenceNode) <> "Nothing" Then
                'if the node as no children, we get from the SGBD all his childrens
                If lo_ReferenceNode.children = 0 Then
                    If li_CursElements < UBound(la_ElementsArray) Then
                        FillLevel lo_ReferenceNode, TreeViewGetHeight(lo_ReferenceNode) + 1, TreeViewGetPath(lo_ReferenceNode), TreeViewGetView(lo_ReferenceNode), Trim(la_ElementsArray(li_CursElements + 1))
                    Else
                        FillLevel lo_ReferenceNode, TreeViewGetHeight(lo_ReferenceNode) + 1, TreeViewGetPath(lo_ReferenceNode), TreeViewGetView(lo_ReferenceNode), ""
                    End If
                    MouseOff
                End If
            Else
                ' Can't append, the first level is always present
                    ls_Key = TreeViewGetNewKey
                    li_OldReferenceNodeHeight = TreeViewGetHeight(lo_OldReferenceNode)
                    ls_OldReferenceNodeView = TreeViewGetView(lo_OldReferenceNode)
                    li_pos = GetIDStoredProcedure(li_OldReferenceNodeHeight + 1, ls_OldReferenceNodeView)
                    If li_pos <> 0 Then
                        ls_Desc = GetSGBDNodeDescription(li_pos, la_ElementsArray(li_CursElements))
                        Set lo_OldReferenceNode = TreeView1.Nodes(1)
                        If TypeName(lo_OldReferenceNode) <> "Nothing" Then
                            Do While TypeName(lo_OldReferenceNode.Next) <> "Nothing"
                                If StrComp(lo_OldReferenceNode.Next.Text, ls_Desc, vbTextCompare) = 1 Then
                                    Exit Do
                                End If
                                Set lo_OldReferenceNode = lo_OldReferenceNode.Next
                            Loop
                        End If
                        lo_InsertOutlineData.ls_ID = la_ElementsArray(li_CursElements)
                        lo_InsertOutlineData.lb_DirectoryData = KO
                        lo_InsertOutlineData.lb_TerminalData = KO
                        lo_InsertOutlineData.lb_TerminalDirectoryData = KO
                        lo_InsertOutlineData.ls_ViewCode = ""
                        mo_OutlineAdditionalInformation.Add lo_InsertOutlineData, ls_Key
                        Set lo_InsertedNode = TreeView1.Nodes.Add(lo_OldReferenceNode, tvwNext, ls_Key, ls_Desc)
                        
                        lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                        
                        If ms_OutlineParameter(8, li_pos) = "Asc" Then TreeView1.Sorted = OK
                        
                        FillLevel lo_InsertedNode, TreeViewGetHeight(lo_InsertedNode) + 1, TreeViewGetPath(lo_InsertedNode), TreeViewGetView(lo_InsertedNode), ""
                        MouseOff
                        Set lo_ReferenceNode = lo_InsertedNode
                    End If
'                Exit For
            End If
        Else 'so, we not open the first level of the tree
            Set lo_OldReferenceNode = lo_ReferenceNode
            Set lo_ReferenceNode = TreeViewFindChildElementByCode(TreeView1, lo_ReferenceNode, Trim(la_ElementsArray(li_CursElements)))
            If TypeName(lo_ReferenceNode) <> "Nothing" Then
                If lo_ReferenceNode.children = 0 Then
                    If li_CursElements < UBound(la_ElementsArray) Then
                        FillLevel lo_ReferenceNode, TreeViewGetHeight(lo_ReferenceNode) + 1, TreeViewGetPath(lo_ReferenceNode), TreeViewGetView(lo_ReferenceNode), Trim(la_ElementsArray(li_CursElements + 1))
                    Else
                        FillLevel lo_ReferenceNode, TreeViewGetHeight(lo_ReferenceNode) + 1, TreeViewGetPath(lo_ReferenceNode), TreeViewGetView(lo_ReferenceNode), ""
                    End If
                    MouseOff
                End If
            Else
                ' if the element is a leaf, we don't add it because it must not appear
                ' the procedure will be certainly fired by a change in filter's values
                ' otherwise
                'ms_OutlineParameter(8,li_CursElements )
                If ms_OutlineParameter(5, li_CursElements) = "Y" Then
                    Set lo_ReferenceNode = lo_OldReferenceNode
                    Exit For
                Else
                    ' otherwise the node must appear the client was not synchronised with the SGBD
                    ls_Key = TreeViewGetNewKey
                    li_OldReferenceNodeHeight = TreeViewGetHeight(lo_OldReferenceNode)
                    ls_OldReferenceNodeView = TreeViewGetView(lo_OldReferenceNode)
                    li_pos = GetIDStoredProcedure(li_OldReferenceNodeHeight + 1, ls_OldReferenceNodeView)
                    If li_pos <> 0 Then
                        lo_InsertOutlineData.ls_ID = la_ElementsArray(li_CursElements)
                        lo_InsertOutlineData.lb_DirectoryData = KO
                        lo_InsertOutlineData.lb_TerminalData = KO
                        lo_InsertOutlineData.lb_TerminalDirectoryData = KO
                        lo_InsertOutlineData.ls_ViewCode = ""
                        mo_OutlineAdditionalInformation.Add lo_InsertOutlineData, ls_Key
                        Set lo_InsertedNode = TreeView1.Nodes.Add(lo_OldReferenceNode, tvwChild, ls_Key, GetSGBDNodeDescription(li_pos, la_ElementsArray(li_CursElements)))
                        
                        If ms_OutlineParameter(8, li_pos) = "Asc" Then lo_OldReferenceNode.Sorted = OK
                        
                        lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINEFOLDER)
                        FillLevel lo_InsertedNode, TreeViewGetHeight(lo_InsertedNode) + 1, TreeViewGetPath(lo_InsertedNode), TreeViewGetView(lo_InsertedNode), ""
                        MouseOff
                        Set lo_ReferenceNode = lo_InsertedNode
                    End If
                End If
            End If
        End If
    Next
    
    
    If (TypeName(lo_ReferenceNode) <> "Nothing") Then
        lo_ReferenceNode.EnsureVisible
        lo_ReferenceNode.Selected = OK
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(TreeView1.SelectedItem.Key)
        If lo_OutlineData.lb_TerminalData Then
            ms_LeafCode = lo_OutlineData.ls_ID
            If lb_NoEvents = False Then
            RaiseEvent EvtLeafClick(ms_LeafCode, TreeView1.SelectedItem.Text)
            End If
        Else
            If lb_NoEvents = False Then
            RaiseEvent EvtNodeClick(lo_OutlineData.ls_ID, TreeView1.SelectedItem.Text)
        End If
        End If
    Else
        If TypeName(TreeView1.SelectedItem) <> "Nothing" Then
            TreeView1.SelectedItem.Selected = KO
        End If
        ms_LeafCode = ""
        If lb_NoEvents = False Then
        RaiseEvent EvtLooseSelection
    End If
    End If
    
    MouseOn
End Sub


Private Function TreeViewFindChildElementByCode(ByRef lo_TreeView As TreeView, ByRef lo_BaseNode As Node, ByVal ls_Code As String) As Node
On Error GoTo Err_TreeViewFindChildElementByCode
Dim lo_OutlineData As OutlineData
Dim lo_CursNode As Node
Dim lb_Found As Boolean

    Set TreeViewFindChildElementByCode = Nothing
    If TypeName(lo_BaseNode) = "Nothing" Then
        Set lo_CursNode = lo_TreeView.Nodes.Item(1)
        
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_CursNode.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            Do While lo_OutlineData.lb_TerminalDirectoryData <> OK
                Set lo_CursNode = lo_CursNode.Child
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_CursNode.Key)
            Loop
        End If
    Else
        Set lo_CursNode = lo_BaseNode.Child
        
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_CursNode.Key)
        If lo_OutlineData.lb_DirectoryData = OK Then
            Do While lo_OutlineData.lb_TerminalDirectoryData <> OK
                Set lo_CursNode = lo_CursNode.Child
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_CursNode.Key)
            Loop
        End If
    End If
    
    lb_Found = KO
    Do While TypeName(lo_CursNode) <> "Nothing"
        Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(lo_CursNode.Key)
        If lo_OutlineData.ls_ID = ls_Code Then
            lb_Found = OK
            Exit Do
        End If
        'Set lo_CursNode = lo_CursNode.Next
        Set lo_CursNode = TreeViewGetNext(lo_BaseNode, lo_CursNode)
    Loop
    
    If lb_Found Then
        Set TreeViewFindChildElementByCode = lo_CursNode
    End If
    
    

    Exit Function
Err_TreeViewFindChildElementByCode:
    Set TreeViewFindChildElementByCode = Nothing
End Function


Private Sub TreeViewPrintNode(lo_Node As Node)
'------------------------------------------------------------------
' Name :TreeViewPrintNode
'
' Purpose : Print in the opened printer flow, the tree (started at the given node)
'
' Param :   lo_Node :
'
' review : 16/Mar/2000 by JJB
'------------------------------------------------------------------

'This routine is called recursively to work down the tree and
' print the information
Dim lo_CursNode As Node
Dim ls_Text As String
Dim li_Indent As Integer
Dim ls_Tab As String

    ls_Tab = "  "

    Set lo_CursNode = lo_Node

    Do While TypeName(lo_CursNode) <> "Nothing"
        li_Indent = 0
        ls_Text = ""
        While li_Indent < TreeViewGetHeight(lo_CursNode)
            ls_Text = ls_Text & ls_Tab
            li_Indent = li_Indent + 1
        Wend
        Printer.Print ls_Text & " " & lo_CursNode.Text
        If (lo_CursNode.children > 0) Then
            TreeViewPrintNode lo_CursNode.Child
        End If
        Set lo_CursNode = lo_CursNode.Next
    Loop
End Sub

Private Function TreeViewTryAddOnPath(ByVal ls_path As String, ByVal ls_Code As String, ByVal ls_Desc As String) As Boolean
Dim la_ElementsArray() As String
Dim li_CursElements  As Integer
'Dim lo_TempElement As Node
Dim lo_ReferenceNode As Node
Dim lb_FolderNotOpen As Boolean
Dim ls_NewKey As String
Dim lo_InsertedNode As Node
Dim lo_OutlineData As OutlineData
Dim li_ReferenceNodeHeight As Integer
Dim ls_ReferenceNodeView As String
Dim li_pos As Integer
Dim i As Integer
Dim lb_Create As Boolean
Dim ls_OrderType  As String
Dim lo_ChildNode As Node

    TreeViewTryAddOnPath = KO
    lb_FolderNotOpen = KO
    la_ElementsArray = SplitString(ls_path, "\")
    For li_CursElements = 1 To UBound(la_ElementsArray) - 1
        'Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
        If mb_FirstLevelInCombo And li_CursElements = 1 Then
            If TypeName(mo_ViewCombo) = "ComboBox" Then
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(MCombo_GetCode(mo_ViewCombo))
            Else
                Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(mo_ViewCombo.Code)
            End If
            If lo_OutlineData.ls_ID <> la_ElementsArray(1) Then
                lb_FolderNotOpen = OK
                Exit For
            End If
        Else
            If li_CursElements = 1 Then
                Set lo_ReferenceNode = TreeViewFindChildElementByCode(TreeView1, Nothing, la_ElementsArray(li_CursElements))
                If TypeName(lo_ReferenceNode) <> "Nothing" Then
                    If lo_ReferenceNode.children = 0 Then
                        lb_FolderNotOpen = OK
                        Exit For
                    End If
                Else
                    lb_FolderNotOpen = OK
                    Exit For
                End If
            Else
                Set lo_ReferenceNode = TreeViewFindChildElementByCode(TreeView1, lo_ReferenceNode, la_ElementsArray(li_CursElements))
                If TypeName(lo_ReferenceNode) <> "Nothing" Then
                    If lo_ReferenceNode.children = 0 Then
                        lb_FolderNotOpen = OK
                        Exit For
                    End If
                Else
                    lb_FolderNotOpen = OK
                    Exit For
                End If
            End If
        End If
    Next




    If (TypeName(lo_ReferenceNode) <> "Nothing") And (lb_FolderNotOpen = KO) Then

        'If TypeName(lo_ReferenceNode.Child) <> "Nothing" Then
            li_ReferenceNodeHeight = TreeViewGetHeight(lo_ReferenceNode)
            ls_ReferenceNodeView = TreeViewGetView(lo_ReferenceNode)
            ' find type of order
            li_pos = 0
            For i = 1 To UBound(ms_OutlineParameter, 2)
'                If li_ReferenceNodeHeight = 1 Then
'                    If CInt(ms_OutlineParameter(1, i)) = li_ReferenceNodeHeight + 1 And ms_OutlineParameter(2, i) = "" Then
'                        li_Pos = i
'                        Exit For
'                    End If
'                Else
                    If CInt(ms_OutlineParameter(1, i)) = li_ReferenceNodeHeight + 1 And (ms_OutlineParameter(2, i)) = ls_ReferenceNodeView Then
                        li_pos = i
                        Exit For
                    End If
'                End If
            Next i



            ls_NewKey = TreeViewGetNewKey()

            ls_OrderType = ms_OutlineParameter(8, li_pos)
            If ms_OutlineParameter(5, li_pos) = "N" Then
                'The last node is not a leaf
                If li_CursElements = UBound(la_ElementsArray) Then
                    TreeViewOpenPath ls_path, , True
                End If
                Exit Function
            End If
            
            Select Case ls_OrderType
            Case "Asc"
                'insert it alphabetic order
                Set lo_InsertedNode = TreeView1.Nodes.Add(lo_ReferenceNode, tvwChild, ls_NewKey, ls_Desc)
                lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                Set lo_OutlineData = New OutlineData
                lo_ReferenceNode.Sorted = OK
                lo_OutlineData.lb_TerminalData = OK
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalDirectoryData = KO
                'the level is not a view
                lo_OutlineData.ls_ViewCode = ""
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                TreeViewTryAddOnPath = OK
            'Case "Desc"
            Case "First"
                'insert it in first position
                Set lo_InsertedNode = TreeView1.Nodes.Add(lo_ReferenceNode.Child, tvwFirst, ls_NewKey, ls_Desc)
                lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                Set lo_OutlineData = New OutlineData
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalData = OK
                lo_OutlineData.lb_TerminalDirectoryData = KO
                'the level is not a view
                lo_OutlineData.ls_ViewCode = ""
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                TreeViewTryAddOnPath = OK
            Case "Last"
                'OK
                'insert it in first position
                Set lo_InsertedNode = TreeView1.Nodes.Add(lo_ReferenceNode.Child, tvwLast, ls_NewKey, ls_Desc)
                lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                Set lo_OutlineData = New OutlineData
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalData = OK
                lo_OutlineData.lb_TerminalDirectoryData = KO
                'the level is not a view
                lo_OutlineData.ls_ViewCode = ""
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                TreeViewTryAddOnPath = OK
            Case Else
                'insert it alphabetic order
                Set lo_InsertedNode = TreeView1.Nodes.Add(lo_ReferenceNode, tvwChild, ls_NewKey, ls_Desc)
                lo_InsertedNode.Image = "RES" & CStr(RES_OUTLINELEAF)
                lo_OutlineData.lb_TerminalData = OK
                Set lo_OutlineData = New OutlineData
                lo_OutlineData.ls_ID = ls_Code
                lo_OutlineData.lb_TerminalDirectoryData = KO
                'the level is not a view
                lo_OutlineData.ls_ViewCode = ""
                mo_OutlineAdditionalInformation.Add Item:=lo_OutlineData, Key:=ls_NewKey
                TreeViewTryAddOnPath = OK
            End Select
        'Else
            'FillLevel0 lo_ReferenceNode
        'End If
    End If

End Function



Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    Call PropBag.WriteProperty("ToolTipText", TreeView1.ToolTipText, "")
End Sub


Private Sub SetComboView(ByVal ls_Code)
Dim li_Count As Integer
Dim ls_CursComboCode As String
Dim lo_OutlineData As OutlineData

On Error GoTo SetComboView_Err

For li_Count = 0 To mo_ViewCombo.ListCount - 1
    If TypeName(mo_ViewCombo) = "ComboBox" Then
        ls_CursComboCode = mo_ViewCombo.Column(1, li_Count)
    Else
        ls_CursComboCode = mo_ViewCombo.Code(li_Count)
    End If
    Set lo_OutlineData = mo_OutlineAdditionalInformation.Item(ls_CursComboCode)
    If lo_OutlineData.ls_ID = ls_Code Then
        mo_ViewCombo.ListIndex = li_Count
        Exit Sub
    End If
Next li_Count

SetComboView_Err:
    mo_ViewCombo.ListIndex = -1
End Sub
